package open.batoru.data.cards;

import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;

public final class SIGNI_K3_OrizelDissonaNaturalBacteria extends Card {

    public SIGNI_K3_OrizelDissonaNaturalBacteria()
    {
        setImageSets("WXDi-P12-088");

        setOriginalName("羅菌　オリゼル//ディソナ");
        setAltNames("ラキンオリゼルディソナ Rakin Orizeru Disona");
        setDescription("jp",
                "@U：このシグニがアタックしたとき、対戦相手のデッキの上からカードを６枚トラッシュに置く。"
        );

        setName("en", "Oryzill//Dissona, Natural Bacteria");
        setDescription("en",
                "@U: Whenever this SIGNI attacks, put the top six cards of your opponent's deck into their trash."
        );
        
        setName("en_fan", "Orizel//Dissona, Natural Bacteria");
        setDescription("en_fan",
                "@U: Whenever this SIGNI attacks, put the top 6 cards of your opponent's deck into the trash."
        );

        setName("zh_simplified", "罗菌 米酒酵母//失调");
        setDescription("zh_simplified", 
                "@U :当这只精灵攻击时，从对战对手的牌组上面把6张牌放置到废弃区。"
        );

        setCardFlags(CardFlag.DISSONA);

        setType(CardType.SIGNI);
        setColor(CardColor.BLACK);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.BACTERIA);
        setLevel(3);
        setPower(10000);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH, PlayFormat.CHINESE);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            registerAutoAbility(GameEventId.ATTACK, this::onAutoEff);
        }
        
        private void onAutoEff()
        {
            millDeck(getOpponent(), 6);
        }
    }
}
