package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.GameConst.GamePhase;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.AbilityConst.UseLimit;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.cost.TrashCost;

public final class SIGNI_R3_HHeartArrowCrimsonAngelPrincess extends Card {

    public SIGNI_R3_HHeartArrowCrimsonAngelPrincess()
    {
        setImageSets("WX25-P3-056");
        setLinkedImageSets("WX25-P3-019");

        setOriginalName("紅天姫　Hハートアロー");
        setAltNames("コウテンキエイチハートアロー Koutenki Eichi Haato Aroo");
        setDescription("jp",
                "@U：あなたのアタックフェイズ開始時、あなたの場に他の＜天使＞のシグニがある場合、以下の２つから１つを選ぶ。\n" +
                "$$1このシグニをアップする。\n" +
                "$$2ターン終了時まで、このシグニのパワーを＋3000する。\n" +
                "@A $T1 @[エナゾーンから＜天使＞のシグニ１枚をトラッシュに置く]@：あなたの場に《天弓へ一歩　ヒラナ》がいる場合、ターン終了時まで、このシグニは@>@U：このシグニがアタックしたとき、このシグニのパワー以下の対戦相手のシグニ１体を対象とし、それをバニッシュする。@@を得る。"
        );

        setName("en", "H Heart Arrow, Crimson Angel Princess");
        setDescription("en",
                "@U: At the beginning of your attack phase, if there is another <<Angel>> SIGNI on your field, @[@|choose 1 of the following:|@]@\n" +
                "$$1 Up this SIGNI.\n" +
                "$$2 Until end of turn, this SIGNI gets +3000 power.\n" +
                "@A $T1 @[Put 1 <<Angel>> SIGNI from your ener zone into the trash]@: If your LRIG is \"Hirana, One Step Towards Heaven's Bow\", until end of turn, this SIGNI gains:" +
                "@>@U: Whenever this SIGNI attacks, target 1 of your opponent's SIGNI with power equal to or less than this SIGNI's power, and banish it."
        );

        setType(CardType.SIGNI);
        setColor(CardColor.RED);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.ANGEL);
        setLevel(3);
        setPower(10000);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            AutoAbility auto = registerAutoAbility(GameEventId.PHASE_START, this::onAutoEff);
            auto.setCondition(this::onAutoEffCond);

            ActionAbility act = registerActionAbility(new TrashCost(new TargetFilter().SIGNI().withClass(CardSIGNIClass.ANGEL).fromEner()), this::onActionEff);
            act.setUseLimit(UseLimit.TURN, 1);
        }

        private ConditionState onAutoEffCond()
        {
            return isOwnTurn() && getCurrentPhase() == GamePhase.ATTACK_PRE ? ConditionState.OK : ConditionState.BAD;
        }
        private void onAutoEff(CardIndex caller)
        {
            if(new TargetFilter().own().SIGNI().withClass(CardSIGNIClass.ANGEL).except(getCardIndex()).getValidTargetsCount() > 0)
            {
                if(playerChoiceMode() == 1)
                {
                    up();
                } else {
                    gainPower(getCardIndex(), 3000, ChronoDuration.turnEnd());
                }
            }
        }
        
        private void onActionEff()
        {
            if(getLRIG(getOwner()).getIndexedInstance().getName().getValue().contains("天弓へ一歩　ヒラナ"))
            {
                AutoAbility attachedAuto = new AutoAbility(GameEventId.ATTACK, this::onAttachedAutoEff);
                attachAbility(getCardIndex(), attachedAuto, ChronoDuration.turnEnd());
            }
        }
        private void onAttachedAutoEff()
        {
            CardIndex target = playerTargetCard(new TargetFilter(TargetHint.BANISH).OP().SIGNI().withPower(0, getPower().getValue())).get();
            banish(target);
        }
    }
}
