package open.batoru.data.cards;

import open.batoru.core.Deck.DeckPosition;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.AbilityConst.ActionHint;

public final class SIGNI_W1_MartielHolyAngel extends Card {
    
    public SIGNI_W1_MartielHolyAngel()
    {
        setImageSets("WXDi-P06-043");
        
        setOriginalName("聖天　マルティエル");
        setAltNames("セイテンマルティエル Seiten Marutieru");
        setDescription("jp",
                "@E：対戦相手のトラッシュからカード１枚を対象とし、それをデッキの一番下に置く。" +
                "~#：あなたのデッキの上からカードを３枚見る。その中からシグニ１枚を公開し手札に加えるか場に出し、残りを好きな順番でデッキの一番下に置く。"
        );
        
        setName("en", "Martiel, Blessed Angel");
        setDescription("en",
                "@E: Put target card from your opponent's trash on the bottom of their deck." +
                "~#Look at the top three cards of your deck. Reveal a SIGNI from among them and add it to your hand or put it onto your field. Put the rest on the bottom of your deck in any order."
        );

        setName("es", "Martiel, Ángel Divino");
        setDescription("es",
                "@E: Selecciona 1 carta de la basura de tu oponente y ponla en el fondo de su mazo." +
                "~#Mira 3 cartas del tope de tu mazo, revela 1 SIGNI de entre ellas y añadela a tu mano o ponla en el campo, pon el resto en el fondo del mazo en cualquier orden."
        );
        
        setName("en_fan", "Martiel, Holy Angel");
        setDescription("en_fan",
                "@E: Target 1 card from your opponent's trash, and put it on the bottom of their deck." +
                "~#Look at the top 3 cards of your deck. Reveal 1 SIGNI from among them, and add it to your hand or put it onto the field, and put the rest on the bottom of your deck in any order."
        );

        setName("zh_simplified", "圣天 玛露缇耶尔");
        setDescription("zh_simplified", 
                "@E :从对战对手的废弃区把1张牌作为对象，将其放置到牌组最下面。" +
                "~#从你的牌组上面看3张牌。从中把精灵1张公开加入手牌或出场，剩下的任意顺序放置到牌组最下面。"
        );
        
        setCardFlags(CardFlag.LIFEBURST);
        
        setType(CardType.SIGNI);
        setColor(CardColor.WHITE);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.ANGEL);
        setLevel(1);
        setPower(3000);
        
        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH, PlayFormat.CHINESE);
    }
    
    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            registerEnterAbility(this::onEnterEff);
            
            registerLifeBurstAbility(this::onLifeBurstEff);
        }
        
        private void onEnterEff()
        {
            CardIndex target = playerTargetCard(new TargetFilter(TargetHint.BOTTOM).OP().fromTrash()).get();
            returnToDeck(target, DeckPosition.BOTTOM);
        }
        
        private void onLifeBurstEff()
        {
            look(3);
            
            CardIndex cardIndex = playerTargetCard(0,1, new TargetFilter().own().SIGNI().fromLooked()).get();
            if(reveal(cardIndex))
            {
                if(playerChoiceAction(ActionHint.HAND, ActionHint.FIELD) == 1 || !putOnField(cardIndex))
                {
                    addToHand(cardIndex);
                }
            }
            
            returnToDeckOrdered(CardLocation.LOOKED, DeckPosition.BOTTOM);
        }
    }
}
