package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.DataTable;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.CardColor;
import open.batoru.data.CardConst.CardFlag;
import open.batoru.data.CardConst.CardType;
import open.batoru.data.CardConst.PlayFormat;
import open.batoru.data.Cost;

public final class SPELL_B_TROUBLE extends Card {
    
    public SPELL_B_TROUBLE()
    {
        setImageSets("WXDi-P01-068", "SPDi01-54","SPDi37-02");
        
        setOriginalName("TROUBLE");
        setAltNames("トラブル Toraburu");
        setDescription("jp",
                "カードを３枚引く。" +
                "~#：対戦相手のシグニを２体まで対象とし、それらをダウンする。"
        );
        
        setName("en", "Trouble");
        setDescription("en",
                "Draw three cards." +
                "~#Down up to two target SIGNI on your opponent's field."
        );
        
        setName("en_fan", "TROUBLE");
        setDescription("en_fan",
                "Draw 3 cards." +
                "~#Target up to 2 of your opponent's SIGNI, and down them."
        );

        setName("zh_simplified", "TROUBLE");
        setDescription("zh_simplified", 
                "抽3张牌。" +
                "~#对战对手的精灵2只最多作为对象，将这些横置。"
        );
        
        setCardFlags(CardFlag.LIFEBURST);
        
        setType(CardType.SPELL);
        setColor(CardColor.BLUE);
        setCost(Cost.color(CardColor.BLUE, 1) + Cost.colorless(1));
        
        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH);
    }
    
    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            registerSpellAbility(this::onSpellEff);
            
            registerLifeBurstAbility(this::onLifeBurstEff);
        }
        
        private void onSpellEff()
        {
            draw(3);
        }
        
        private void onLifeBurstEff()
        {
            DataTable<CardIndex> data = playerTargetCard(0,2, new TargetFilter(TargetHint.DOWN).OP().SIGNI());
            down(data);
        }
    }
}
