package open.batoru.data.cards;

import open.batoru.core.Deck.DeckPosition;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.CardColor;
import open.batoru.data.CardConst.CardFlag;
import open.batoru.data.CardConst.CardType;
import open.batoru.data.CardConst.PlayFormat;
import open.batoru.data.Cost;
import open.batoru.data.DataTable;

public final class SPELL_W_GetAlmandel extends Card {

    public SPELL_W_GetAlmandel()
    {
        setImageSets("WX24-P4-061");

        setOriginalName("ゲット・アルマンデル");
        setAltNames("ゲットアルマンデル Getto Arumanderu");
        setDescription("jp",
                "あなたのデッキの上からカードを５枚見る。その中からレベル２以下のシグニを２枚まで公開し手札に加え、残りを好きな順番でデッキの一番下に置く。あなたの場にレベル４以上のルリグがいる場合、代わりにその中からシグニを２枚まで公開し手札に加え、残りを好きな順番でデッキの一番下に置く。" +
                "~#：対戦相手のアップ状態のシグニ１体を対象とし、それを手札に戻す。"
        );

        setName("en", "Get Almandel");
        setDescription("en",
                "Look at the top 5 cards of your deck. Reveal up to 2 level 2 or lower SIGNI from among them, add them to your hand, and put the rest on the bottom of your deck in any order. If there is a level 4 or higher LRIG on your field, instead reveal up to 2 SIGNI from among them, add them to your hand, and put the rest on the bottom of your deck in any order." +
                "~#Target of your opponent's upped SIGNI, and return it to their hand."
        );

        setName("zh_simplified", "获得·奥尔曼达尔之书");
        setDescription("zh_simplified", 
                "从你的牌组上面看5张牌。从中把等级2以下的精灵2张最多公开加入手牌，剩下的任意顺序放置到牌组最下面。你的场上有等级4以上的分身的场合，作为替代，从中把精灵2张最多公开加入手牌，剩下的任意顺序放置到牌组最下面。" +
                "~#对战对手的竖直状态的精灵1只作为对象，将其返回手牌。"
        );

        setCardFlags(CardFlag.LIFEBURST);

        setType(CardType.SPELL);
        setColor(CardColor.WHITE);
        setCost(Cost.color(CardColor.WHITE, 1));

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            registerSpellAbility(this::onSpellEff);

            registerLifeBurstAbility(this::onLifeBurstEff);
        }
        
        private void onSpellEff()
        {
            look(5);
            
            TargetFilter filter = new TargetFilter().own().SIGNI().fromLooked();
            if(getLRIG(getOwner()).getIndexedInstance().getLevel().getValue() < 4) filter = filter.withLevel(0,2);

            DataTable<CardIndex> data = playerTargetCard(0,2, filter);
            reveal(data);
            addToHand(data);
            
            returnToDeckOrdered(CardLocation.LOOKED, DeckPosition.BOTTOM);
        }

        private void onLifeBurstEff()
        {
            CardIndex target = playerTargetCard(new TargetFilter(TargetHint.HAND).OP().SIGNI().upped()).get();
            addToHand(target);
        }
    }
}
